<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Twig\Extension;

use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

class EncodeExtension extends AbstractExtension
{
    public function getFilters(): array
    {
        return [
            new TwigFilter('base64_encode', fn ($value) => base64_encode($value)),
            new TwigFilter('base64_decode', fn ($value) => base64_decode($value, true)),
            new TwigFilter('sha1', fn ($value) => sha1($value)),
        ];
    }
}
