<?php

declare(strict_types=1);

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Twig\Extension;

use Serenity\CoreBundle\Service\BreadcrumbBuilder;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class BreadcrumbExtension extends AbstractExtension
{
    public function __construct(private BreadcrumbBuilder $builder)
    {
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('breadcrumbs', $this->getBreadcrumbs(...)),
        ];
    }

    /**
     * @return array<int, array{label: string, uri: string|null, entity?: object}>
     */
    public function getBreadcrumbs(): array
    {
        return $this->builder->build();
    }
}
