<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Trait;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

trait SerenitySaasTrait
{
    #[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
    private ?string $saasIdentifier = null;

    #[ORM\Column(type: Types::BOOLEAN, options: ['default' => true])]
    private bool $saasIdentifierAutoGenerated = true;

    public function getSaasIdentifier(): ?string
    {
        return $this->saasIdentifier;
    }

    public function setSaasIdentifier(?string $saasIdentifier = null): void
    {
        $this->saasIdentifier = $saasIdentifier;
    }

    public function isSaasIdentifierAutoGenerated(): bool
    {
        return $this->saasIdentifierAutoGenerated;
    }

    public function setSaasIdentifierAutoGenerated(bool $saasIdentifierAutoGenerated): void
    {
        $this->saasIdentifierAutoGenerated = $saasIdentifierAutoGenerated;
    }
}
