<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Notifier\Notification;

use Serenity\CoreBundle\Mercure\Topics;
use Serenity\CoreBundle\Mercure\TopicsGenerator;
use Serenity\CoreBundle\Notifier\Transport\MercureCustomOptions;
use Symfony\Component\Notifier\Message\ChatMessage;
use Symfony\Component\Notifier\Notification\ChatNotificationInterface;
use Symfony\Component\Notifier\Notification\Notification;
use Symfony\Component\Notifier\Recipient\RecipientInterface;

class PushSettings extends Notification implements ChatNotificationInterface
{
    public function getChannels(RecipientInterface $recipient): array
    {
        return ['chat/mercure'];
    }

    public function asChatMessage(?RecipientInterface $recipient = null, ?string $transport = null): ChatMessage
    {
        $options = new MercureCustomOptions(TopicsGenerator::privateWindowIdTopic(Topics::TOPIC_SETTINGS->value), true);

        return ChatMessage::fromNotification($this)->options($options)->subject($this->getContent());
    }
}
