<?php

declare(strict_types=1);

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Messenger;

use Serenity\CoreBundle\Event\DomainEvent;
use Serenity\CoreBundle\Event\EventBusInterface;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\Messenger\Envelope;
use Symfony\Component\Messenger\MessageBusInterface;
use Symfony\Component\Messenger\Stamp\DispatchAfterCurrentBusStamp;

final readonly class EventBus implements EventBusInterface
{
    public function __construct(private MessageBusInterface $eventBus, private EventDispatcherInterface $dispatcher)
    {
    }

    public function publish(DomainEvent ...$domainEvents): void
    {
        foreach ($domainEvents as $currentEvent) {
            if ($currentEvent->isDispatcher()) {
                $this->dispatcher->dispatch($currentEvent);
            } else {
                $this->eventBus->dispatch(
                    (new Envelope($currentEvent))->with(new DispatchAfterCurrentBusStamp())
                );
            }
        }
    }
}
