<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Mercure;

enum Topics: string
{
    case SUBSCRIBE_ADMIN = '/admin';
    case TOPIC_NOTIFIER = '/notifier';
    case TOPIC_SETTINGS = '/settings';

    public static function subscribeUser(string $userId): string
    {
        return \sprintf('/users/%s/{?topic}', $userId);
    }
}
