<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\EventListener;

use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Component\HttpKernel\Event\ControllerEvent;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Error\SyntaxError;

final readonly class ResourceListener
{
    public function __construct(
        private EntityManagerInterface $em,
    ) {
    }

    /**
     * @throws RuntimeError
     * @throws SyntaxError
     * @throws LoaderError
     */
    #[AsEventListener(event: ControllerEvent::class)]
    public function onKernelController(ControllerEvent $event): void
    {
        $request = $event->getRequest();
        $route = $request->attributes->get('_route');
        $id = $request->attributes->get('id');
        $entityClass = $request->attributes->get('entity');

        // conditions : route doit finir par _edit + avoir un paramètre id + avoir un entity défini
        if (!$route || !str_ends_with($route, '_edit') || !$id || !$entityClass) {
            return;
        }

        $entity = $this->em->getRepository($entityClass)->find($id);
        $request->attributes->set('entity_instance', $entity);

        if (!$entity) {
            throw new NotFoundHttpException(\sprintf('%s with id "%s" not found.', $entityClass, $id));
        }
    }
}
