<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\EventListener;

use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\UX\TwigComponent\Event\PreRenderEvent;

#[AsEventListener(event: PreRenderEvent::class)]
final class ComponentTemplateListener
{
    public function __invoke(PreRenderEvent $event): void
    {
        $vars = $event->getVariables();
        // si une variable "template" est passée, on l’utilise comme override
        if (!empty($vars['template']) && \is_string($vars['template'])) {
            $event->setTemplate($vars['template']);
            unset($vars['template']);
            $event->setVariables($vars);
        }
    }
}
