<?php

declare(strict_types=1);

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Event;

abstract class DomainEvent
{
    private const string DATE_FORMAT = 'Y-m-d H:i:s';

    public function __construct(private readonly bool $dispatcher = false, private ?string $occurredOn = null)
    {
        $this->occurredOn = $occurredOn ?? (new \DateTimeImmutable())->format(self::DATE_FORMAT);
    }

    public function occurredOn(): ?string
    {
        return $this->occurredOn;
    }

    public function isDispatcher(): bool
    {
        return $this->dispatcher;
    }
}
