<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Serenity\CoreBundle\Aggregate\AggregateRoot;
use Serenity\CoreBundle\Aggregate\AggregateRootInterface;
use Serenity\CoreBundle\Contract\SerenitySaasInterface;
use Serenity\CoreBundle\Trait\DisabledTrait;
use Serenity\CoreBundle\Trait\IdentifierTrait;
use Serenity\CoreBundle\Trait\SerenitySaasTrait;
use Serenity\CoreBundle\Trait\TimestampTrait;
use Serenity\ShopBundle\Doctrine\Repository\CatalogRepository;

#[ORM\Table(name: 'serenity_core_domain')]
#[ORM\Entity(repositoryClass: CatalogRepository::class)]
#[ORM\HasLifecycleCallbacks]
class Domain implements AggregateRootInterface, SerenitySaasInterface
{
    use AggregateRoot;
    use DisabledTrait;
    use IdentifierTrait {
        IdentifierTrait::__construct as private identifierConstruct;
    }
    use SerenitySaasTrait;
    use TimestampTrait;
}
