<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Contract;

interface SearchInterface
{
    /**
     * @var array<int, string>
     */
    public const array DIRECTION = ['ASC', 'DESC'];

    /**
     * @var array<string, string|array{property: string}>
     */
    public const SORTER = [];

    public function getQuery(): ?string;

    public function getDirection(): ?string;

    /**
     * @return array<string, string|array{property: string}>
     */
    public function getSorter(): array;

    /**
     * @param array<string, mixed> $data
     */
    public static function fromArray(array $data): self;

    /**
     * @return array<string, mixed>
     */
    public function toArray(): array;
}
