<?php

declare(strict_types=1);

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Aggregate;

use Serenity\CoreBundle\Event\DomainEvent;
use Symfony\Component\Serializer\Attribute\Ignore;

trait AggregateRoot
{
    /** @var array<DomainEvent> */
    #[Ignore]
    private array $domainEvents = [];

    final public function recordEvent(DomainEvent $domainEvent): void
    {
        $this->domainEvents[] = $domainEvent;
    }

    final public function domainEventsEmpty(): bool
    {
        return empty($this->domainEvents);
    }

    /**
     * @return array<DomainEvent>
     */
    final public function pullDomainEvents(): array
    {
        $recordedEvents = $this->domainEvents;
        $this->domainEvents = [];

        return $recordedEvents;
    }
}
