import {startStimulusApp} from "@symfony/stimulus-bridge";
import {definitionsFromContext} from '@hotwired/stimulus-webpack-helpers';
class StimulusManager {
    constructor() {
        if (!StimulusManager.instance) {
            this.app = startStimulusApp(
                require.context(
                    "@symfony/stimulus-bridge/lazy-controller-loader!../controllers/auto",
                    true,
                    /\.(j|t)sx?$/
                )
            );
            StimulusManager.instance = this;
            this.app.registerActionOption("confirm", ({event, value}) => {
                if (event.params && event.params.confirmMessage == null) {
                    return true;
                }

                if (confirm(event.params.confirmMessage)) {
                    return true;
                } else {
                    return false;
                }
            });
        }

        return StimulusManager.instance;
    }

    register(identifier, controller) {
        this.app.register(identifier, controller);

    }

    load(requireContext) {
        this.app.load(definitionsFromContext(requireContext));
    }

}

// Exporter une unique instance que tous les fichiers partageront
const stimulusManager = new StimulusManager();
export default stimulusManager;
