<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Service;

use Serenity\CoreBundle\Mercure\PushBuilder;
use Serenity\CoreBundle\Notifier\Notification\AlertNotification;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Session\Flash\FlashBagInterface;

class FlashService
{
    private const SESSION_KEY = '_custom_flashes';

    public function __construct(private readonly RequestStack $requestStack, private PushBuilder $pushBuilder)
    {
    }

    public function add(
        string $message,
        string $level = AlertNotification::LEVEL_SUCCESS,
    ): void {
        $session = $this->requestStack->getSession();
        /** @var FlashBagInterface $flashBag */
        $flashBag = $session->getBag('flashes');
        $flashBag->add($level, $message);
    }

    /**
     * Envoie les messages instantanément.
     */
    public function push(string $message,
        string $level = AlertNotification::LEVEL_SUCCESS,
        string $type = AlertNotification::TYPE_ADMIN): void
    {
        $this->pushBuilder->createAlertNotification($message, $level, $type);
    }

    /**
     * Retourne et vide les flashs.
     *
     * @return FlashMessage[]
     */
    public function all(): array
    {
        $session = $this->requestStack->getSession();
        $flashes = $session->get(self::SESSION_KEY, []);
        $session->remove(self::SESSION_KEY);

        return $flashes;
    }
}
