<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Service;

use Serenity\CoreBundle\Notifier\Notification\AlertNotification;

readonly class FlashMessage
{
    public function __construct(
        private string $message,
        private string $level = AlertNotification::LEVEL_SUCCESS,
        private string $type = AlertNotification::TYPE_ADMIN,
    ) {
    }

    public function getMessage(): string
    {
        return $this->message;
    }

    public function getLevel(): string
    {
        return $this->level;
    }

    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return array{message: string, level: string, type: string}
     */
    public function toArray(): array
    {
        return [
            'message' => $this->message,
            'level' => $this->level,
            'type' => $this->type,
        ];
    }
}
