<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Serializer;

use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

final class PassThroughMixedArrayDenormalizer implements DenormalizerInterface
{
    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        // Quand le Serializer veut "mixed[]" et qu'on a déjà un array, on laisse passer tel quel
        return 'mixed[]' === $type && \is_array($data);
    }

    public function denormalize($data, $type, $format = null, array $context = []): mixed
    {
        return $data;
    }

    // Important pour les perfs (Symfony >= 6.3)
    public function getSupportedTypes(?string $format): array
    {
        return ['mixed[]' => true]; // true = cacheable
    }
}
