<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Mercure;

use Psr\Container\ContainerInterface;
use Serenity\CoreBundle\Notifier\Notification\AlertNotification;
use Serenity\CoreBundle\Notifier\Notification\PushSettings;
use Symfony\Component\DependencyInjection\Attribute\AutowireLocator;
use Symfony\Component\Notifier\NotifierInterface;
use Twig\Environment;

readonly class PushBuilder
{
    public function __construct(
        #[AutowireLocator([
            'twig' => Environment::class, // 🔹 Services injectés en lazy-loading
        ])]
        private ContainerInterface $locator,
        private NotifierInterface $notifier,
    ) {
    }

    public function createAlertNotification(string $message, string $level = AlertNotification::LEVEL_SUCCESS, string $type = AlertNotification::TYPE_ADMIN): void
    {
        /** @phpstan-ignore-next-line */
        $twig = $this->locator->get('twig');
        $template = $twig->render(\sprintf('@stream/notifier/alert/%s.stream.html.twig', $type), ['level' => $level, 'message' => $message]);
        $this->notifier->send((new AlertNotification())->content($template));
    }

    public function pushSettings(string $template): void
    {
        /** @phpstan-ignore-next-line */
        $twig = $this->locator->get('twig');
        $template = $twig->render($template);
        $this->notifier->send((new PushSettings())->content($template));
    }
}
