<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Doctrine\EventListener;

use Doctrine\Bundle\DoctrineBundle\Attribute\AsDoctrineListener;
use Doctrine\ORM\Event\LoadClassMetadataEventArgs;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

#[AsDoctrineListener(event: 'loadClassMetadata')]
class OwnerMappingSubscriber
{
    public function __construct(private ParameterBagInterface $params)
    {
    }

    public function loadClassMetadata(LoadClassMetadataEventArgs $args): void
    {
        $metadata = $args->getClassMetadata();

        // Ne traite que les entités qui utilisent OwnerTrait
        if (!\in_array('Serenity\CoreBundle\Trait\OwnerTrait', class_uses($metadata->getName()), true)) {
            return;
        }

        // Vérifie que UserInterface existe (donc que le bundle Auth est chargé)
        if (!$this->params->has('serenity_auth.user_class')) {
            return;
        }

        // Si le champ existe déjà, on ne fait rien
        if ($metadata->hasAssociation('owner')) {
            return;
        }

        // Ajoute dynamiquement le mapping ManyToOne
        $metadata->mapManyToOne([
            'fieldName' => 'owner',
            'targetEntity' => $this->params->get('serenity_auth.user_class'), // ou une classe concrète si nécessaire
            'joinColumns' => [
                [
                    'name' => 'owner_id',
                    'referencedColumnName' => 'id',
                    'nullable' => true,
                    'onDelete' => 'SET NULL',
                ],
            ],
        ]);
    }
}
