<?php

declare(strict_types=1);

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Doctrine\Contract;

use Doctrine\Common\Collections\Collection;

interface NestedTreeInterface
{
    public function getRoot(): ?self;

    public function setRoot(?self $root): void;

    public function getParent(): ?self;

    public function setParent(?self $parent): void;

    public function getLvl(): int;

    public function setLvl(int $lvl): void;

    public function getLft(): int;

    public function setLft(int $lft): void;

    public function getRgt(): int;

    public function setRgt(int $rgt): void;

    /**
     * @return Collection<self>
     */
    public function getChildren(): Collection;
}
