<?php

declare(strict_types=1);

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Doctrine\Contract;

use Doctrine\ORM\QueryBuilder;
use Gedmo\Tree\RepositoryInterface;
use Symfony\Component\Uid\Uuid;

interface NestedRepositoryInterface extends RepositoryInterface
{
    public function save(object $object): void;

    public function remove(object $object): void;

    public function persist(object $object): void;

    public function flush(): void;

    public function findOneById(Uuid|int $id): ?object;

    /** @return array<object> */
    public function treeArray(?object $node = null): array;

    /** @return array<object> */
    public function tree(): array;

    public function treeQuery(?object $node = null): QueryBuilder;

    public function reorderForce(?object $node = null): QueryBuilder;
}
