<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\CoreBundle\Config;

use Serenity\CoreBundle\Contract\ConfigInterface;
use Symfony\Component\Validator\Constraints as Assert;

class CoreConfig implements ConfigInterface
{
    public const string NAME = 'core';

    #[Assert\NotBlank()]
    #[Assert\Length(min: 2, max: 255)]
    public string $company;

    public function getName(): string
    {
        return self::NAME;
    }

    public function isSaasIdentifierConfig(): bool
    {
        return false;
    }
}
