<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AuthBundle\Query;

use Doctrine\ORM\EntityManagerInterface;
use Serenity\CoreBundle\Bus\QueryHandlerInterface;
use Serenity\CoreBundle\Contract\UserInterface;

readonly class UserByEmailQueryHandler implements QueryHandlerInterface
{
    public function __construct(
        private EntityManagerInterface $em,
    ) {
    }

    public function __invoke(UserAdminByEmailQuery $query): ?UserInterface
    {
        /* @phpstan-ignore-next-line */
        return $this->em->getRepository(UserInterface::class)->findOne($query->email, $query->role);
    }
}
