<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AuthBundle\Query;

use Doctrine\ORM\EntityManagerInterface;
use Serenity\CoreBundle\Bus\QueryHandlerInterface;
use Serenity\CoreBundle\Contract\UserInterface;
use Serenity\SaasBundle\Entity\Tenant;
use Symfony\Component\DependencyInjection\Attribute\Autowire;

readonly class UserAdminByEmailQueryHandler implements QueryHandlerInterface
{
    public function __construct(
        private EntityManagerInterface $em,
        #[Autowire('%serenity_saas%')]
        private bool $serenitySaas,
    ) {
    }

    public function __invoke(UserAdminByEmailQuery $query): ?UserInterface
    {
        if ($this->serenitySaas) {
            /** @var UserInterface|null $user */
            $user = $this->em->getRepository(Tenant::class)->findOneBy(['email' => $query->email]);
        } else {
            /** @var UserInterface|null $user */
            /* @phpstan-ignore-next-line */
            $user = $this->em->getRepository(UserInterface::class)->findOne($query->email, $query->role);
        }

        return $user;
    }
}
