<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AuthBundle\Model;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Serenity\AuthBundle\Doctrine\Repository\UserRepository;
use Serenity\AuthBundle\Entity\AbstractUser;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

#[ORM\Entity(repositoryClass: UserRepository::class)]
#[ORM\Table(name: 'serenity_auth_user')]
#[ORM\UniqueConstraint(name: 'unique_email_per_project', columns: ['email', 'saasIdentifier'], options: ['nulls_not_distinct' => true])]
#[UniqueEntity(fields: ['email.value', 'saasIdentifier'], message: 'entity.unique.user')]
#[ORM\HasLifecycleCallbacks]
#[Gedmo\SoftDeleteable(fieldName: 'deletedAt', timeAware: false, hardDelete: true)]
class User extends AbstractUser
{
}
