<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AuthBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\Length;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\PasswordStrength;

class ChangePasswordFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('plainPassword', RepeatedType::class, [
                'translation_domain' => 'form',
                'type' => PasswordType::class,
                'options' => [
                    'attr' => [
                        'autocomplete' => 'new-password',
                    ],
                ],
                'first_options' => ['constraints' => [
                    new NotBlank([
                        'message' => 'form.password-not-blank',
                    ]),
                    new PasswordStrength([], PasswordStrength::STRENGTH_WEAK),
                    new Length([
                        'min' => 8,
                        'minMessage' => 'form.password-min-8-characters',
                        'max' => 4096,
                    ]),
                ], 'label' => 'form.password', 'attr' => ['autocomplete' => 'new-password'], 'help_attr' => ['class' => 'text-xs mt-2'], 'help' => 'form.password-min-8-characters'],
                'second_options' => ['label' => 'form.password-repeat', 'attr' => ['autocomplete' => 'new-password']],
                'invalid_message' => 'form.password-no-match',
                'mapped' => false,
                'error_mapping' => [
                    '.' => 'first',
                ],
            ]);

        parent::buildForm($builder, $options);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
        ]);
    }
}
