<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AuthBundle\Command;

use Serenity\CoreBundle\Message\MailConfigurableMessageInterface;

readonly class WelcomeEmailCommand implements MailConfigurableMessageInterface
{
    /**
     * @param string $id | User id
     */
    public function __construct(
        public string $id,
    ) {
    }

    public function getMessageClass(): ?string
    {
        return self::class;
    }
}
