<?php

declare(strict_types=1);

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AuthBundle\Command;

use Serenity\CoreBundle\Bus\SyncCommandInterface;

final readonly class CreateUserCommand implements SyncCommandInterface
{
    /**
     * @param non-empty-string $email
     * @param string[]         $roles
     */
    public function __construct(
        public string $email,
        public string $plainPassword,
        public array $roles = [],
        public bool $test = false,
    ) {
    }
}
