<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AuthBundle\Exception;

use Symfony\Component\Security\Core\Exception\CustomUserMessageAuthenticationException;

class TooManyBadCredentialsException extends CustomUserMessageAuthenticationException
{
    /**
     * @param string[] $messageData
     */
    public function __construct(
        string $message = 'Le compte a été verrouillé suite à de trop nombreuses tentatives de connexion',
        array $messageData = [],
        int $code = 0,
        ?\Throwable $previous = null,
    ) {
        parent::__construct($message, $messageData, $code, $previous);
    }
}
