<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AuthBundle\EventListener;

use Serenity\AuthBundle\Command\WelcomeEmailCommand;
use Serenity\AuthBundle\Event\UserCreatedEvent;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Component\Messenger\MessageBusInterface;

#[AsEventListener(event: UserCreatedEvent::class)]
final readonly class CreateUserListener
{
    public function __construct(private readonly MessageBusInterface $commandBus)
    {
    }

    public function __invoke(UserCreatedEvent $user): void
    {
        $command = new WelcomeEmailCommand($user->id);
        $this->commandBus->dispatch($command);
    }
}
