<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AuthBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Serenity\CoreBundle\Trait\IdentifierTrait;
use Serenity\CoreBundle\Trait\TimestampTrait;
use Serenity\MediaBundle\Entity\Image;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity]
#[ORM\Table(name: 'serenity_auth_profile')]
#[ORM\HasLifecycleCallbacks]
class Profile
{
    use IdentifierTrait {
        IdentifierTrait::__construct as private identifierConstruct;
    }
    use TimestampTrait;

    #[Assert\NotBlank]
    #[Assert\Length(min: 1, max: 255)]
    #[ORM\Column(length: 255)]
    private string $firstname;

    #[Assert\NotBlank]
    #[Assert\Length(min: 1, max: 255)]
    #[ORM\Column(length: 255)]
    private string $lastname;

    #[Assert\Length(min: 1, max: 255)]
    #[ORM\Column(length: 255, nullable: true)]
    private ?string $company = null;

    #[Assert\Valid]
    #[ORM\OneToOne(targetEntity: Image::class, cascade: ['all'])]
    #[ORM\JoinColumn(name: 'avatar_id', referencedColumnName: 'id', onDelete: 'SET NULL')]
    private ?Image $avatar = null;

    public function getFirstname(): string
    {
        return $this->firstname;
    }

    public function setFirstname(string $firstname): void
    {
        $this->firstname = $firstname;
    }

    public function getLastname(): string
    {
        return $this->lastname;
    }

    public function setLastname(string $lastname): void
    {
        $this->lastname = $lastname;
    }

    public function getCompany(): ?string
    {
        return $this->company;
    }

    public function setCompany(?string $company): void
    {
        $this->company = $company;
    }

    public function fullName(): string
    {
        return $this->firstname.' '.$this->lastname;
    }

    public function getAvatar(): ?Image
    {
        return $this->avatar;
    }

    public function setAvatar(?Image $avatar): void
    {
        if (null === $avatar) {
            $this->avatar = null;

            return;
        }

        $file = $avatar->getFile();
        $uploaded = $avatar->getUploadedFile();

        if (!$uploaded && (!$file || !$file->getName())) {
            $this->avatar = null;

            return;
        }

        $this->avatar = $avatar;
    }
}
