<?php

declare(strict_types=1);

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AuthBundle\Command;

use Serenity\AuthBundle\Doctrine\Repository\UserRepository;
use Serenity\AuthBundle\Exception\NoUniqueUserException;
use Serenity\AuthBundle\Model\User;
use Serenity\AuthBundle\Query\UserAdminByEmailQuery;
use Serenity\CoreBundle\Bus\CommandHandlerInterface;
use Serenity\CoreBundle\Bus\QueryBusInterface;
use Serenity\CoreBundle\Contract\UserInterface;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;

#[AsMessageHandler]
final readonly class CreateUserCommandHandler implements CommandHandlerInterface
{
    public function __construct(private QueryBusInterface $queryBus, private UserRepository $userRepository)
    {
    }

    public function __invoke(CreateUserCommand $command): UserInterface
    {
        if ($this->queryBus->ask(new UserAdminByEmailQuery($command->email))) {
            throw new NoUniqueUserException($command->email);
        }
        $user = new User(
            $command->email,
            $command->plainPassword,
            $command->roles,
            $command->test
        );

        $this->userRepository->save($user);

        return $user;
    }
}
