<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AuthBundle\Cli;

use Serenity\AuthBundle\Command\CreateUserCommand;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Messenger\MessageBusInterface;

#[AsCommand(
    name: 'serenity:auth:create-user',
    description: 'Create a new user.',
    hidden: false
)]
class CreateUserCli extends Command
{
    public function __construct(private readonly MessageBusInterface $commandBus)
    {
        parent::__construct();
    }

    protected function configure(): void
    {
        $this
          ->addArgument('login', InputArgument::REQUIRED, 'User Email')
          ->addArgument('password', InputArgument::REQUIRED, 'User password')
          ->addArgument(
              'roles',
              InputOption::VALUE_OPTIONAL,
              'Role USER, by default ROLE_SUPER_ADMIN ',
              ['ROLE_SUPER_ADMIN']
          )
          ->addArgument(
              'test',
              InputOption::VALUE_OPTIONAL,
              'password',
              null
          );
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        // outputs multiple lines to the console (adding "\n" at the end of each line)
        $output->writeln([
            'User Creator',
            '============',
            '',
        ]);
        $command = new CreateUserCommand($input->getArgument('login'), $input->getArgument('password'), $input->getArgument('roles'), $input->getArgument('test'));
        $this->commandBus->dispatch($command);

        $output->writeln([
            '============',
            'User Created with success',
            '',
        ]);

        return Command::SUCCESS;
    }
}
