<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AuthBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;

class AdminLoginType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
          ->add('_username', EmailType::class, [
              'label' => 'auth.username',
              'attr' => [
                  'placeholder' => 'auth.username',
              ],
              'translation_domain' => 'serenity_auth_form',
              'required' => true,
          ])
          ->add('_password', PasswordType::class, [
              'label' => 'auth.password',
              'attr' => [
                  'placeholder' => 'auth.password',
              ],
              'translation_domain' => 'serenity_auth_form',
              'required' => true,
          ])
          ->add('_remember', CheckboxType::class, [
              'label' => 'auth.remember_me',
              'translation_domain' => 'serenity_auth_form',
              'required' => false,
          ])
          ->add('login', SubmitType::class, [
              'label' => 'auth.login',
              'icon_prefix' => '<path stroke-linecap="round" stroke-linejoin="round" d="m12.75 15 3-3m0 0-3-3m3 3h-7.5M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />',
              'translation_domain' => 'serenity_auth_form',
          ]);
    }

    public function getBlockPrefix(): string
    {
        return '';
    }
}
