<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AuthBundle\Exception;

class NoUniqueUserException extends \RuntimeException
{
    public function __construct(string $email, int $code = 0, ?\Throwable $previous = null)
    {
        parent::__construct(\sprintf('A user already exists with email %s', $email), $code, $previous);
    }
}
