<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AuthBundle\Event;

use Serenity\CoreBundle\Event\DomainEvent;

final class UserCreatedEvent extends DomainEvent
{
    /**
     * @param string $id | User Id
     */
    public function __construct(
        public readonly string $id,
        public readonly string $email,
        public readonly string $plainPassword,
        public readonly \DateTime $createdAt,
        ?string $occurredOn = null)
    {
        parent::__construct(true, $occurredOn);
    }
}
