<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AuthBundle\Authentication;

use Serenity\CoreBundle\Mercure\PushBuilder;
use Serenity\CoreBundle\Notifier\Notification\AlertNotification;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Security\Core\Exception\AuthenticationException;
use Symfony\Component\Security\Http\Authentication\AuthenticationFailureHandlerInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

final readonly class AuthenticationAdminFailureHandler implements AuthenticationFailureHandlerInterface
{
    public function __construct(private PushBuilder $pushBuilder, private RouterInterface $router, private TranslatorInterface $translator)
    {
    }

    public function onAuthenticationFailure(Request $request, AuthenticationException $exception): Response
    {
        $this->pushBuilder->createAlertNotification($this->translator->trans('security.authentication.failure', [], 'serenity_auth_messages.admin'), AlertNotification::LEVEL_LOGIN_ERROR);

        return new RedirectResponse($this->router->generate('admin_login'));
    }
}
