<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AdminBundle\Twig\Extension;

use Serenity\AdminBundle\Service\FormThemeLocator;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class FormThemeExtension extends AbstractExtension
{
    /**
     * @param FormThemeLocator $locator
     *                                  Le service responsable de localiser les templates Twig
     *                                  correspondant aux thèmes de formulaires d’administration
     */
    public function __construct(private readonly FormThemeLocator $locator)
    {
    }

    /**
     * Enregistre une nouvelle fonction Twig appelée `admin_form_themes`.
     * Celle-ci sera accessible dans les templates Twig.
     *
     * Exemple d'utilisation dans Twig :
     *     {% for theme in admin_form_themes() %}
     *         {% form_theme form theme %}
     *     {% endfor %}
     */
    public function getFunctions(): array
    {
        return [
            new TwigFunction('admin_form_themes', $this->getAdminThemes(...)),
        ];
    }

    /**
     * Récupère la liste complète des chemins Twig vers les fichiers de thèmes
     * situés dans les répertoires `form/admin/` de tous les bundles et du dossier `src`.
     *
     * Cette méthode délègue la recherche au service `FormThemeLocator`.
     *
     * @return string[] liste des chemins Twig des thèmes de formulaire
     */
    public function getAdminThemes(): array
    {
        return $this->locator->getAdminFormThemes();
    }
}
