<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AdminBundle\Twig\Components\Modal;

use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\UX\TwigComponent\Attribute\AsTwigComponent;
use Symfony\UX\TwigComponent\Attribute\PreMount;

#[AsTwigComponent(template: '@components/SerenityAdmin/Modal/FormModal.html.twig')]
class FormModal
{
    public bool $open = false;
    /**
     * @var array<string, FormView>|FormView
     */
    public array|FormView $formFields = [];
    public ?string $icon = null;
    public ?string $text = null;
    public ?string $title = null;
    public ?string $modalButton = null;
    public bool $closeButton = true;

    /**
     * @param array<string, mixed> $data
     *
     * @return array<string, mixed>
     */
    #[PreMount]
    public function preMount(array $data): array
    {
        $resolver = new OptionsResolver();
        $resolver->setIgnoreUndefined(true);
        $resolver->setDefined(['formFields']);
        $resolver->setDefined('icon');
        $resolver->setDefined('text');
        $resolver->setDefined('title');
        $resolver->setDefined('closeButton');
        $resolver->setDefined('modalButton');
        $resolver->setDefaults(['open' => false]);
        $resolver->setAllowedTypes('open', 'bool');
        $resolver->setAllowedTypes('icon', ['string', 'null']);
        $resolver->setAllowedTypes('text', ['string', 'null']);
        $resolver->setAllowedTypes('title', ['string', 'null']);
        $resolver->setAllowedTypes('modalButton', ['string', 'null']);
        $resolver->setAllowedTypes('closeButton', 'bool');
        $resolver->setAllowedTypes('formFields', ['array', FormView::class]);

        return $resolver->resolve($data) + $data;
    }
}
