<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AdminBundle\Form\Type;

use Serenity\AdminBundle\Config\CardSidebar;
use Serenity\CoreBundle\Form\Type\CkeditorType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\UrlType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class CardSidebarType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('title', TextType::class, [
            'label' => 'Titre',
            'attr' => [
                'autocomplete' => 'off',
            ],
            'required' => false,
        ])
            ->add('text', CkeditorType::class, [
                'label' => 'Contenu',
                'attr' => [
                    'autocomplete' => 'off',
                ],
                'required' => false,
            ])
            ->add('buttonText', TextType::class, [
                'label' => 'Texte du bouton',
                'attr' => [
                    'autocomplete' => 'off',
                ],
                'required' => false,
            ])
            ->add('buttonUrl', UrlType::class, [
                'label' => 'Url du button',
                'attr' => [
                    'autocomplete' => 'off',
                ],
                'required' => false,
            ])
            ->add('enabled', CheckboxType::class, [
                'label' => 'Visible',
                'required' => false,
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults(
            [
                'data_class' => CardSidebar::class,
                'empty_data' => new CardSidebar(), // Pouvoir faire fonctionner les Assert dand cette class avec Ux live
            ]
        );
    }
}
