<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AdminBundle\Controller;

use Serenity\AuthBundle\Command\ResetPasswordCommand;
use Serenity\AuthBundle\Enum\ResetPasswordType;
use Serenity\AuthBundle\Form\Type\ResetPasswordRequestFormType;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Messenger\MessageBusInterface;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;

class LostPasswordController extends AbstractController
{
    #[Route(path: ['en' => '/lost-password'], name: 'admin_forgot_password_request')]
    public function __invoke(AuthenticationUtils $authenticationUtils, Request $request, MessageBusInterface $commandBus): void
    {
        $form = $this->createForm(ResetPasswordRequestFormType::class);
        $form->handleRequest($request);

        $commandBus->dispatch(new ResetPasswordCommand($form->getData()->getEmail(), ResetPasswordType::ADMIN));
    }
}
