<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AdminBundle\Config;

use Doctrine\ORM\Mapping as ORM;
use Serenity\CoreBundle\Contract\ConfigInterface;
use Serenity\MediaBundle\Entity\Image;
use Symfony\Component\Validator\Constraints as Assert;

class SuperAdminConfig implements ConfigInterface
{
    public const string NAME = 'admin';

    #[Assert\NotBlank]
    #[Assert\Length(min: 2, max: 255)]
    private ?string $title = null;

    private bool $searchInput = false;

    private bool $notificationPanel = false;

    #[Assert\Valid]
    private ?CardSidebar $cardSidebar = null;

    #[Assert\Valid]
    #[ORM\OneToOne(targetEntity: Image::class, cascade: ['all'])]
    #[ORM\JoinColumn(name: 'image_id', referencedColumnName: 'id', onDelete: 'SET NULL')]
    private ?Image $logo = null;

    public function getName(): string
    {
        return self::NAME;
    }

    public function isSaasIdentifierConfig(): bool
    {
        return false;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(?string $title): void
    {
        $this->title = $title;
    }

    public function isSearchInput(): bool
    {
        return $this->searchInput;
    }

    public function setSearchInput(bool $searchInput): void
    {
        $this->searchInput = $searchInput;
    }

    public function isNotificationPanel(): bool
    {
        return $this->notificationPanel;
    }

    public function setNotificationPanel(bool $notificationPanel): void
    {
        $this->notificationPanel = $notificationPanel;
    }

    public function getLogo(): ?Image
    {
        return $this->logo;
    }

    public function setLogo(?Image $logo = null): void
    {
        $this->logo = $logo;
    }

    public function getCardSidebar(): ?CardSidebar
    {
        return $this->cardSidebar;
    }

    public function setCardSidebar(?CardSidebar $cardSidebar): void
    {
        $this->cardSidebar = $cardSidebar;
    }
}
