<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AdminBundle\EventListener;

use Serenity\AdminBundle\Event\ParamsSuperAdminMenuEvent;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Component\Security\Core\Authorization\AuthorizationCheckerInterface;

#[AsEventListener()]
readonly class ParamsSuperAdminMenuListener
{
    public function __construct(private AuthorizationCheckerInterface $authorizationChecker)
    {
    }

    public function __invoke(ParamsSuperAdminMenuEvent $event): void
    {
        $menu = $event->getMenu();
        if ($menu && $this->authorizationChecker->isGranted('ROLE_SUPER_ADMIN')) {
            $menu->addChild('super_admin_admin', ['label' => 'Administration', 'route' => 'admin_config_super_admin']);
        }
    }
}
