<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AdminBundle\Config;

use Serenity\CoreBundle\Constraint\AssertNormalizer;
use Serenity\CoreBundle\Contract\EmptyInterface;
use Symfony\Component\Validator\Constraints as Assert;

class CardSidebar implements EmptyInterface
{
    #[Assert\Length(min: 2, max: 16)]
    private ?string $title = null;

    #[Assert\Length(min: 2, max: 255, normalizer: [AssertNormalizer::class, 'stripTags'])]
    private ?string $text = null;

    #[Assert\Length(min: 2, max: 16)]
    #[Assert\When(
        expression: 'this.getButtonUrl() != null',
        constraints: [
            new Assert\NotBlank(),
        ]
    )]
    private ?string $buttonText = null;

    #[Assert\Url]
    #[Assert\When(
        expression: 'this.getButtonText() != null',
        constraints: [
            new Assert\NotBlank(),
        ]
    )]
    private ?string $buttonUrl = null;

    private bool $enabled = true;

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(?string $title): void
    {
        $this->title = $title;
    }

    public function getText(): ?string
    {
        return $this->text;
    }

    public function setText(?string $text): void
    {
        $this->text = $text;
    }

    public function getButtonText(): ?string
    {
        return $this->buttonText;
    }

    public function setButtonText(?string $buttonText): void
    {
        $this->buttonText = $buttonText;
    }

    public function getButtonUrl(): ?string
    {
        return $this->buttonUrl;
    }

    public function setButtonUrl(?string $buttonUrl): void
    {
        $this->buttonUrl = $buttonUrl;
    }

    public function isEnabled(): bool
    {
        return $this->enabled;
    }

    public function setEnabled(bool $enabled): void
    {
        $this->enabled = $enabled;
    }

    public function isEmpty(): bool
    {
        /*
         * Dans le formulaire, nous devons instancier un object avec empty_ddata pour faire fonctionner les Assert de cette classe.
         * Mais nous ne voulons persister null et non l'object avec les valeurs null.
        **/
        if (null === $this->title && null === $this->text && null === $this->buttonText) {
            return true;
        }

        return false;
    }
}
