<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AdminBundle\Cache;

use Serenity\AdminBundle\Service\FormThemeLocator;
use Symfony\Component\Cache\Adapter\ArrayAdapter;
use Symfony\Component\Cache\Adapter\PhpArrayAdapter;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Component\HttpKernel\CacheWarmer\CacheWarmerInterface;

class FormThemeCacheWarmer implements CacheWarmerInterface
{
    private string $cacheFile;

    public function __construct(
        private readonly FormThemeLocator $locator,
        #[Autowire('%kernel.cache_dir%')]
        string $cacheDir)
    {
        $this->cacheFile = $cacheDir.'/serenity/form_theme_cache.php';
    }

    public function warmUp(string $cacheDir, ?string $buildDir = null): array
    {
        $themes = $this->locator->scanThemes(); // pas getAdminFormThemes pour éviter lecture de cache
        $cache = new PhpArrayAdapter($this->cacheFile, new ArrayAdapter());
        $cache->warmUp([
            'admin_form_themes' => $themes,
        ]);

        return [];
    }

    public function isOptional(): bool
    {
        return false;
    }
}
