import Sortable from '@stimulus-components/sortable';
import {getComponent} from '@symfony/ux-live-component';

export default class extends Sortable {

    async initialize() {
        super.initialize();
        this.component = await getComponent(this.element.closest('[data-controller~="live"]'));
    }
    connect() {
        super.connect()
        this.defaultOptions
    }

    updateGridClasses() {
        if (this.element.classList.contains('grid')) {
            const items = this.element.querySelectorAll("div[id]")
            items.forEach((el, index) => {
                el.classList.remove("row-span-2", "col-span-2")
                if (index === 0) {
                    el.classList.add("row-span-2", "col-span-2")
                }
            });
        }
    }

    // You can override the `onUpdate` method here.
    async onUpdate(event) {
        super.onUpdate(event)
        await this.component.action('sortable',{ id: event.item.id, newPosition: event.newIndex });
    }

    // You can set default options in this getter for all sortable elements.
    get defaultOptions() {
        return {
            animation: 500,
            onChange: (evt) => this.updateGridClasses(evt),
            onEnd: (evt) => this.updateGridClasses()
        }
    }
}
