import {Controller} from '@hotwired/stimulus';

export default class extends Controller {
    static values = {
        path: String
    }
    static targets = ["modal"]

    connect() {
        this.previousUrl = sessionStorage.getItem('previousUrl');
    }

    close() {
        // Alpine doit être initialisé
        const component = Alpine && Alpine.$data(this.element)
        if (!component) {
            this.element.remove()
            Turbo.visit(this.getBackUrl())
            return
        }

        // Ferme la modal (déclenche les transitions Alpine)
        component.open = false

        // Supprime l’élément après la durée de transition (200ms ici)
        setTimeout(() => {
            this.element.remove()
            Turbo.visit(this.getBackUrl())
        }, 200) // <-- adapte à `duration-200` dans ton x-transition
    }

    getBackUrl() {
        if (this.previousUrl.startsWith('/dashboard/settings') || !this.previousUrl) {
            return '/dashboard';
        }

        return this.previousUrl;
    }
}
