<?php

/*
 * This file is part of the Serenity package.
 *
 * (c) CP Creation <web@cpcreation.fr>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Serenity\AdminBundle\Form\Type;

use Serenity\AdminBundle\Config\SuperAdminConfig;
use Serenity\MediaBundle\Form\Type\ImageType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class SuperAdminConfigType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('title', TextType::class, [
            'label' => 'Titre de l\'administration',
            'help' => 'Titre haut de page de l\'administration',
            'attr' => [
                'autocomplete' => 'off',
            ],
            'required' => true,
        ])
            ->add('logo', ImageType::class, [
                'label' => 'Logo de l\'administration',
                'help' => 'Logo haut de page de l\'administration',
                'required' => false,
            ])
            ->add('cardSidebar', CardSidebarType::class, [
                'label' => 'Carte sidebar',
                'required' => false,
            ])
            ->add('notificationPanel', CheckboxType::class, [
                'label' => 'Panneau des notifications',
                'required' => false,
            ])
            ->add('searchInput', CheckboxType::class, [
                'label' => 'Champ de recherche',
                'required' => false,
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults(
            [
                'data_class' => SuperAdminConfig::class,
            ]
        );
    }
}
